
ifeq ($(MPT_PROGRESS_FILE),)
MPT_PROGRESS_FILE:=/dev/null
endif

ifneq ($(words $(MAKECMDGOALS)),1)
.DEFAULT_GOAL = all
%:
	@$(MAKE) $@ --no-print-directory -rRf $(firstword $(MAKEFILE_LIST))
else
ifndef PROGRESS
T := $(shell $(MAKE) $(MAKECMDGOALS) --no-print-directory -nrRf $(firstword $(MAKEFILE_LIST)) PROGRESS="COUNTTHIS" | grep -c "COUNTTHIS")
N := x
C = $(words $N)$(eval N := x $N)
D = $(words $N)$(eval N := $N)
PROGRESS = @echo "`expr \( $C '-' 1 \) '*' 100 / $T`" >$(MPT_PROGRESS_FILE)
PROGRESS_ECHO = @echo "[`printf %3s \`expr \( $D '-' 1 \) '*' 100 / $T\``%]"
endif

PROGRESS_ECHO ?= echo

V?=2
INFO       ?= @echo
SILENT     ?= @
VERYSILENT ?= @

ifeq ($(V),6)
INFO       = @true
SILENT     = 
VERYSILENT = 
endif

ifeq ($(V),5)
INFO       = @true
SILENT     = 
VERYSILENT = 
endif

ifeq ($(V),4)
INFO       = @true
SILENT     = 
VERYSILENT = @
endif

ifeq ($(V),3)
INFO       = @$(PROGRESS_ECHO)
SILENT     = @
VERYSILENT = @
endif

ifeq ($(V),2)
INFO       = @$(PROGRESS_ECHO)
SILENT     = @
VERYSILENT = @
endif

ifeq ($(V),1)
INFO       = @true
SILENT     = @
VERYSILENT = @
endif

ifeq ($(V),0)
INFO       = @true
SILENT     = @
VERYSILENT = @
endif

ifeq ($(MPT_ARCH_BITS),)
MPT_ARCH_TARGET:=
else
MPT_ARCH_TARGET:=-m$(MPT_ARCH_BITS)
endif

MPT_TARGET?=

MPT_TRY_DBUS?=1
MPT_TRY_PORTAUDIO?=1
MPT_TRY_PULSEAUDIO?=1
MPT_TRY_RTAUDIO?=1

CPPFLAGS += $(MPT_ARCH_TARGET)
CXXFLAGS += $(MPT_ARCH_TARGET)
CFLAGS   += $(MPT_ARCH_TARGET)
LDFLAGS  += $(MPT_ARCH_TARGET)
LDLIBS   += 
ARFLAGS  += 

ifeq ($(shell printf '\n' > build/wine/empty.cpp ; if $(CXX) -std=gnu++23 -c build/wine/empty.cpp -o build/wine/empty.out > /dev/null 2>&1 ; then echo 'gnu++23' ; fi ), gnu++23)
CXXFLAGS += -std=gnu++23
else ifeq ($(shell printf '\n' > build/wine/empty.cpp ; if $(CXX) -std=gnu++20 -c build/wine/empty.cpp -o build/wine/empty.out > /dev/null 2>&1 ; then echo 'gnu++20' ; fi ), gnu++20)
CXXFLAGS += -std=gnu++20
else
CXXFLAGS += -std=gnu++17
endif

ifeq ($(shell printf '\n' > build/wine/empty.c ; if $(CC) -std=c23 -c build/wine/empty.c -o build/wine/empty.out > /dev/null 2>&1 ; then echo 'c23' ; fi ), c23)
CFLAGS   += -std=c23
else ifeq ($(shell printf '\n' > build/wine/empty.c ; if $(CC) -std=c18 -c build/wine/empty.c -o build/wine/empty.out > /dev/null 2>&1 ; then echo 'c18' ; fi ), c18)
CFLAGS   += -std=c18
else ifeq ($(shell printf '\n' > build/wine/empty.c ; if $(CC) -std=c17 -c build/wine/empty.c -o build/wine/empty.out > /dev/null 2>&1 ; then echo 'c17' ; fi ), c17)
CFLAGS   += -std=c17
else ifeq ($(shell printf '\n' > build/wine/empty.c ; if $(CC) -std=c11 -c build/wine/empty.c -o build/wine/empty.out > /dev/null 2>&1 ; then echo 'c11' ; fi ), c11)
CFLAGS   += -std=c11
else
CFLAGS   += -std=c99
endif

CPPFLAGS += -Icommon -Isrc -Iinclude/nlohmann-json/include -Iinclude
CXXFLAGS += -fpermissive -fPIC -fvisibility=hidden
CFLAGS   +=              -fPIC -fvisibility=hidden
LDFLAGS  += 
LDLIBS   += -lm -lpthread
ARFLAGS  += 

CXXFLAGS += -Os
CFLAGS   += -Os -fno-strict-aliasing

CXXFLAGS += -Wall -Wextra -Wundef -Wcast-qual -Wcast-align
CFLAGS   += -Wall -Wextra -Wundef -Wcast-qual -Wcast-align

ifeq ($(shell command -v ccache 2>/dev/null 1>/dev/null && echo yes),yes)
CCACHE=ccache
else
CCACHE=
endif

ifeq ($(MPT_TRY_DBUS),2)

ifeq ($(shell $(MPT_TARGET)pkg-config --exists dbus-1 && echo yes),yes)
CPPFLAGS += $(shell $(MPT_TARGET)pkg-config --cflags-only-I dbus-1 ) -DMPT_WITH_DBUS
LDFLAGS  += $(shell $(MPT_TARGET)pkg-config --libs-only-L   dbus-1 ) $(shell $(MPT_TARGET)pkg-config --libs-only-other dbus-1 )
LDLIBS   += $(shell $(MPT_TARGET)pkg-config --libs-only-l   dbus-1 )
CPPFLAGS += -DMPT_WITH_RTKIT
RTKIT_C_SOURCES += include/rtkit/rtkit.c
else
$(error DBus not found.)
endif

else
ifeq ($(MPT_TRY_DBUS),1)

ifeq ($(shell $(MPT_TARGET)pkg-config --exists dbus-1 && echo yes),yes)
CPPFLAGS += $(shell $(MPT_TARGET)pkg-config --cflags-only-I dbus-1 ) -DMPT_WITH_DBUS
LDFLAGS  += $(shell $(MPT_TARGET)pkg-config --libs-only-L   dbus-1 ) $(shell $(MPT_TARGET)pkg-config --libs-only-other dbus-1 )
LDLIBS   += $(shell $(MPT_TARGET)pkg-config --libs-only-l   dbus-1 )
CPPFLAGS += -DMPT_WITH_RTKIT
RTKIT_C_SOURCES += include/rtkit/rtkit.c
endif

endif
endif

ifeq ($(MPT_TRY_PORTAUDIO),2)

ifeq ($(shell $(MPT_TARGET)pkg-config --exists portaudio-2.0 && echo yes),yes)
CPPFLAGS += $(shell $(MPT_TARGET)pkg-config --cflags-only-I portaudio-2.0 ) -DMPT_WITH_PORTAUDIO
LDFLAGS  += $(shell $(MPT_TARGET)pkg-config --libs-only-L   portaudio-2.0 ) $(shell $(MPT_TARGET)pkg-config --libs-only-other portaudio-2.0 )
LDLIBS   += $(shell $(MPT_TARGET)pkg-config --libs-only-l   portaudio-2.0 )
else
$(error PortAudio not found.)
endif

else
ifeq ($(MPT_TRY_PORTAUDIO),1)

ifeq ($(shell $(MPT_TARGET)pkg-config --exists portaudio-2.0 && echo yes),yes)
CPPFLAGS += $(shell $(MPT_TARGET)pkg-config --cflags-only-I portaudio-2.0 ) -DMPT_WITH_PORTAUDIO
LDFLAGS  += $(shell $(MPT_TARGET)pkg-config --libs-only-L   portaudio-2.0 ) $(shell $(MPT_TARGET)pkg-config --libs-only-other portaudio-2.0 )
LDLIBS   += $(shell $(MPT_TARGET)pkg-config --libs-only-l   portaudio-2.0 )
endif

endif
endif

ifeq ($(MPT_TRY_PULSEAUDIO),2)

ifeq ($(shell $(MPT_TARGET)pkg-config --exists libpulse libpulse-simple && echo yes),yes)
CPPFLAGS += $(shell $(MPT_TARGET)pkg-config --cflags-only-I libpulse libpulse-simple ) -DMPT_WITH_PULSEAUDIO -DMPT_WITH_PULSEAUDIOSIMPLE
LDFLAGS  += $(shell $(MPT_TARGET)pkg-config --libs-only-L   libpulse libpulse-simple ) $(shell $(MPT_TARGET)pkg-config --libs-only-other libpulse libpulse-simple )
LDLIBS   += $(shell $(MPT_TARGET)pkg-config --libs-only-l   libpulse libpulse-simple )
else
$(error PulseAudio not found.)
endif

else
ifeq ($(MPT_TRY_PULSEAUDIO),1)

ifeq ($(shell $(MPT_TARGET)pkg-config --exists libpulse libpulse-simple && echo yes),yes)
CPPFLAGS += $(shell $(MPT_TARGET)pkg-config --cflags-only-I libpulse libpulse-simple ) -DMPT_WITH_PULSEAUDIO -DMPT_WITH_PULSEAUDIOSIMPLE
LDFLAGS  += $(shell $(MPT_TARGET)pkg-config --libs-only-L   libpulse libpulse-simple ) $(shell $(MPT_TARGET)pkg-config --libs-only-other libpulse libpulse-simple )
LDLIBS   += $(shell $(MPT_TARGET)pkg-config --libs-only-l   libpulse libpulse-simple )
else
ifeq ($(shell $(MPT_TARGET)pkg-config --exists libpulse && echo yes),yes)
CPPFLAGS += $(shell $(MPT_TARGET)pkg-config --cflags-only-I libpulse ) -DMPT_WITH_PULSEAUDIO
LDFLAGS  += $(shell $(MPT_TARGET)pkg-config --libs-only-L   libpulse ) $(shell $(MPT_TARGET)pkg-config --libs-only-other libpulse )
LDLIBS   += $(shell $(MPT_TARGET)pkg-config --libs-only-l   libpulse )
endif
endif

endif
endif

ifeq ($(MPT_TRY_RTAUDIO),2)

ifeq ($(shell $(MPT_TARGET)pkg-config --exists rtaudio && echo yes),yes)
CPPFLAGS += $(shell $(MPT_TARGET)pkg-config --cflags-only-I rtaudio ) -DMPT_WITH_RTAUDIO
LDFLAGS  += $(shell $(MPT_TARGET)pkg-config --libs-only-L   rtaudio ) $(shell $(MPT_TARGET)pkg-config --libs-only-other rtaudio )
LDLIBS   += $(shell $(MPT_TARGET)pkg-config --libs-only-l   rtaudio )
else
$(error RtAudio not found.)
endif

else
ifeq ($(MPT_TRY_RTAUDIO),1)

ifeq ($(shell $(MPT_TARGET)pkg-config --exists rtaudio && echo yes),yes)
CPPFLAGS += $(shell $(MPT_TARGET)pkg-config --cflags-only-I rtaudio ) -DMPT_WITH_RTAUDIO
LDFLAGS  += $(shell $(MPT_TARGET)pkg-config --libs-only-L   rtaudio ) $(shell $(MPT_TARGET)pkg-config --libs-only-other rtaudio )
LDLIBS   += $(shell $(MPT_TARGET)pkg-config --libs-only-l   rtaudio )
endif

endif
endif

.PHONY: all
all: libopenmpt_native_support.so

%: %.o
	$(PROGRESS)
	$(INFO) Linking $@ ...
	$(SILENT)$(MPT_TARGET)$(LINK.cc) $^ $(LOADLIBES) $(LDLIBS) -o $@

%.o: %.cpp
	$(PROGRESS)
	$(INFO) Compiling $< ...
	$(SILENT)$(CCACHE) $(MPT_TARGET)$(COMPILE.cc) -DMODPLUG_TRACKER -DMPT_BUILD_WINESUPPORT -DMPT_WITH_NLOHMANNJSON $(OUTPUT_OPTION) $<

%.o: %.c
	$(PROGRESS)
	$(INFO) Compiling $< ...
	$(SILENT)$(CCACHE) $(MPT_TARGET)$(COMPILE.c) -DMODPLUG_TRACKER -DMPT_BUILD_WINESUPPORT -DMPT_WITH_NLOHMANNJSON $(OUTPUT_OPTION) $<

COMMON_CXX_SOURCES += $(wildcard common/*.cpp)
MISC_CXX_SOURCES += $(wildcard misc/*.cpp)
SOUNDDEVICE_CXX_SOURCES += $(wildcard src/openmpt/sounddevice/*.cpp)
WINESUPPORT_CXX_SOURCES += $(wildcard mptrack/wine/*.cpp)

OPENMPT_WINESUPPORT_CXX_SOURCES += \
 $(COMMON_CXX_SOURCES) \
 $(MISC_CXX_SOURCES) \
 $(SOUNDDEVICE_CXX_SOURCES) \
 $(WINESUPPORT_CXX_SOURCES) \
 
OPENMPT_WINESUPPORT_C_SOURCES += \
 $(RTKIT_C_SOURCES) \
 
OPENMPT_WINESUPPORT_OBJECTS = $(OPENMPT_WINESUPPORT_CXX_SOURCES:.cpp=.o) $(OPENMPT_WINESUPPORT_C_SOURCES:.c=.o)

OPENMPT_WINESUPPORT_LDFLAGS = -Wl,-z,defs,--no-undefined
LDLIBS_OPENMPT_WINESUPPORT = 

libopenmpt_native_support.so: $(OPENMPT_WINESUPPORT_OBJECTS)
	$(PROGRESS)
	$(INFO) Linking $@ ...
	$(SILENT)$(MPT_TARGET)$(LINK.cc) -shared $(OPENMPT_WINESUPPORT_LDFLAGS) $^ $(LOADLIBS) $(LDLIBS) $(LDLIBS_OPENMPT_WINESUPPORT) -o $@

endif
