
Changelog {#changelog}
=========

For fully detailed change log, please see the source repository directly. This
is just a high-level summary.

### libopenmpt 0.7.15-pre

 *  [**Sec**] Possible out-of-bounds sample data read in a specific combination
    of reverse sample playback + offset past sample loop. (r23712).

 *  [**Bug**] Fixed pre-C++20 undefined behaviour due to left-shifting negative
    integer values.

 *  ogg: Update to v1.3.6 (2025-06-16).

### libopenmpt 0.7.14 (2025-06-14)

 *  [**Bug**] `openmpt::string::get("source_has_mixed_revisions")` and
    `openmpt_get_string("source_has_mixed_revisions")` always returned an empty
    string.
 *  [**Bug**] Work-around broken user locale support on Haiku by always assuming
    UTF8.
 *  [**Bug**] openmpt123: Allow for converting to libsndfile formats which list
    the file extension only in the subformat (i.e. MP3 with libsndfile 1.1.0 or
    later).

 *  MED: Command FFF no longer stops a note if it was triggered on the same row.

 *  mpg123: Update to v1.33.0 (2025-06-07).
 *  miniz: Update to v3.0.2 (2023-01-15).
 *  pugixml: Update to v1.15 (2025-01-10).

### libopenmpt 0.7.13 (2025-01-06)

 *  [**Bug**] Work-around broken user locale support on Cygwin.

 *  `module::get_current_estimated_bpm` could return infinity when rows per beat
    was set to 0. A default of 4 rows per beat is now assumed in this situation.
    The internal LFO plugin was also affected in Tempo Sync mode.
 *  Instruments that have a MIDI channel assigned and NNA set to "Continue"
    could cause NNA channel starvation.
 *  In non-compatible linear slide mode, the sample rate could wrap around with
    portamento slides to extremely low frequencies. This should only happen in
    compatible mode.

 *  mpg123: Update to v1.32.10 (2024-12-14).
 *  XMPlay SDK: Update to 2025-01-03.

### libopenmpt 0.7.12 (2024-12-01)

 *  [**Bug**] Fixed various undefined behaviour found with ubsan.

 *  IT: Don't report files claiming to be made with Impulse Tracker 2.08+ as
    IT-made if they have no edit timer.
 *  IT: Ignore sample data in slots that don't have the "sample data present"
    flag set, if the file vaguely looks IT-made to avoid playing garbage caused
    by an Impulse Tracker bug that should not be audible.
 *  S3M: Detect early Schism Tracker versions.
 *  MOD: When trying to detect MOD files with broken order lists, the file size
    is now rounded down to an even number. This helps identifying some malformed
    files (MOD files can technically not have an odd size).
 *  MOD: Also enable ProTracker-compatible tremolo ramp waveform for
    M!K! modules.
 *  MOD: In ProTracker 1/2 mode, retrigger with instrument-less notes now keeps
    using the previous sample offset.
 *  Warn when a Startrekker AM file most likely requires an (currently
    unsupported) external instrument definition file. 
 *  DBM / IMF / MED: When merging pattern commands, allow to move offset to
    volume column at the expense of a lower offset resolution.
 *  MED: Fix correct octave transposition in some MED files that have hardware
    mixing disabled but sample transpose enabled.
 *  MED: Don't enable Amiga resampler if any stereo samples are found, as it
    does not support stereo samples.
 *  MED: Fix tempo in some files using software mixing mode and legacy tempo
    values.
 *  MED: Avoid importing effect memory for some commands.
 *  MED: Retrigger with instrument-less note now keeps using the previous sample
    offset.
 *  MED: Disable sample swapping on notes with portamento, and don't resume
    stopped notes with portamento.
 *  MED: Only use 7-bit volume commands in MMD3 files made with a new enough
    version of MED Soundstudio.
 *  STM: Do not sanitize sample loop data. Scream Tracker 2 reads into the next
    sample's data when loops exceed the sample length.
 *  When evaluating MIDI macros containing letters "u" or "v" during seeking,
    the initial global volume was applied to them, rather than the global volume
    that would be reached at that pattern position.

 *  mpg123: Update to v1.32.9 (2024-11-02).

### libopenmpt 0.7.11 (2024-10-26)

 *  [**Bug**] The Autotools build system did use `CPPFLAGS`, `CFLAGS`, and
    `CPPFLAGS` directly. This caused build settings to get lost when the user
    overwrote these flags.

 *  IT: Don't import SAx High Offset command for IT 1.xx modules. This feature
    was added in Impulse Tracker 2.00.
 *  IT: Limit Vxx parameter to V80 for files made with old Schism Tracker
    versions.
 *  IT / S3M: Impulse Tracker 2.14 patch version information was incorrect.
 *  S3M: O00 effects are no longer ignored if the tracker version in the file
    header indicates Scream Tracker 3.00 / 3.01, but the file was clearly saved
    with another tool (e.g. UNMO3).
 *  S3M: As files made with Scream Tracker 3.20 and 3.21 cannot be told apart,
    both versions are now listed in the tracker metadata.
 *  ULT: Try to preserve global commands if there's e.g. both a speed and tempo
    command in the same cell.
 *  STM: Improved tracker identification metadata.
 *  SymMOD: When running out of Zxx macros, try to find the closest macro to use
    instead.
 *  SymMOD: Ignore unknown hunks instead of rejecting entire file, as that's
    what Symphonie does as well.
 *  OKT: Disable loop on type "B" samples if they're used on a mixed channel.
 *  OKT: The last sample slot was never loaded.
 *  PTM: Halve offset command strength for 16-bit samples.

 *  mpg123: Update to v1.32.8-dev+r5433 (2024-10-24).

### libopenmpt 0.7.10 (2024-09-22)

 *  [**Change**] FST was added to the list of supported file extension. AMP uses
    this extension for multichannel MODs.

 *  [**Bug**] The Android NDK build system did not enable C++20 when available.

 *  Fixed inconsistency in length calculation and actual playback length with
    tempo commands below 32 BPM in various formats (MDL, MED among others).
 *  MED: Command 09 (set speed) was limited to 20 ticks per row instead of 32
    ticks per row.
 *  MED: Allow tempo parameters < 32 BPM.
 *  MED: Disallow free panning if hardware mixing is enabled.
 *  MED: For MOD-style vibrato, a speed parameter of 0 was not treated as effect
    memory. Vibrato speed is now correct for both vibrato commands.
 *  MED: Fix pattern index exhaustion in modules with multiple subsongs.
 *  OKT: Don't drop global commands when setting paired channel volume, and try
    to write channel volume on the next row in this situation. 
 *  PTM: Use square root pan law, like in XM files.
 *  SFX: Ignore unused data at end of oneshot samples which sometimes caused
    clicky noises.
 *  SFX: More accurate implementation of arpeggio effect.

 *  mpg123: Update to v1.32.7 (2024-08-07).
 *  minimp3: Update to fork
    <https://github.com/manxorist/minimp3/releases/tag/openmpt-2024-08-15-v4>
    commit 2116754771b79347ad2f39127abace2a093c383e (2024-08-15).

### libopenmpt 0.7.9 (2024-07-21)

 *  [**Sec**] Potential division by 0 when seeking in the module with
    `seek.sync_samples` enabled (r21167).

 *  [**Change**] The work-around for
    <https://gcc.gnu.org/bugzilla/show_bug.cgi?id=115049> has been changed from
    forcing `-O1` on GCC 14 to setting `-fno-ipa-ra` on all GCC versions on
    non-ELF platforms. We are still not 100% sure if this work-around is
    sufficient in all circumstances. If you are using a non-ELF platform, it is
    strongly recommended to update GCC to versions 12.5.0, 13.4.0, 14.2.0, or
    15.1.0 as soon as they are released, or to apply the patch from the linked
    GCC issues.

 *  MOD: Allow sample swapping to work when swapping from a non-looping, stopped
    sample back to a looping sample (fixes MOD.energy).
 *  DBM: Import second sustain point in case the first sustain point is not set,
    or if it has a lower index than the first.
 *  DBM: When several instruments referenced the same sample with different
    properties (volume, loop points, etc.), only one set of properties was
    imported (fixes DBM.Supernova).
 *  DBM: Prioritize effects more correctly when the same effect is encountered
    in both effect columns of a cell (fixes DBM.143_Gnoj).
 *  DBM: Don't import offset effects when there's a tone portmento next to them.
 *  DBM: A few IT-specific playback quirks are disabled for more accurate
    playback (e.g. in "Are You Flying With Me?" by Jazzcat).
 *  DIGI: Sample play direction was reset if adjacent channel contained a
    Note Cut note.
 *  AMF: When running out of sample slots, file reading became be misaligned
    because the sample name was not skipped.
 *  MED: Command 0F was not imported.
 *  MED: Upper frequency limits should be more accurate now.
 *  MED: Channel panning is now only applied in MMD2 files if the free pan flag
    is set.
 *  MED: Volume command resolution was incorrect for pre-MMD3 files.
 *  XM: oggmod does not support stereo samples but keeps the stereo flag when
    encoding such samples. Such samples are now imported as mono samples instead
    of not importing them at all.
 *  XM: For files saved with registered MadTracker 2 versions, do not put
    binary garbage (the user ID) in the tracker metadata field. It is replaced
    with "registered" instead.
 *  For some truncated files, the used tracker was not identified correctly. 
 *  S3M: Identify files saved with early Impulse Tracker versions, Sound Club 2,
    Liquid Tracker, NESMusa, UNMO3, deMODifier, Kosmic To-S3M, and better tell
    old ModPlug Tracker versions apart.
 *  S3M: When skipping sample loading, some tracker identifications were not
    working as intended.
 *  IT: Identify files saved with itwriter.
 *  DTM: Identify files saved with Digital Tracker 2.3.

 *  xmp-openmpt: If there is only one subsong, set the song title to the
    "global" song title instead of the name of that subsong.
 *  xmp-openmpt: Sample and instrument names were not sanitized, sometimes
    showing on multiple rows.

### libopenmpt 0.7.8 (2024-06-09)

 *  [**Sec**] Potential heap out-of-bounds read with malformed Dynamic Studio
    DSm files (r20912).

 *  MED: Additional command pages can now be read.
 *  MED: Echo DSP is now emulated.
 *  AMS: Default channel panning was broken, using all-center panning instead of
    MOD-style panning.
 *  STP: Correctly import volume slides where both nibbles are set.
 *  MDL: Pitch slide depth was wrong since libopenmpt 0.6.0.
 *  DTM: Fix pitch slide depth for samples with finetune.
 *  DSm: Don't import as Amiga module (and thus allow Amiga resampler to be
    enabled), as this PC format can easily exceed the Amiga frequency range.
 *  DSm: Only the first 48 samples were ever read.
 *  STM / STX: Don't set channel panning. ScreamTracker 2 only outputs mono
    sound.
 *  PSM: File header probing was stricter than actual file loader, rejecting
    manipulated files that would otherwise load fine.

### libopenmpt 0.7.7 (2024-05-12)

 *  [**Bug**] `examples/libopenmpt_example_c_pipe.c` and
    `libopenmpt/bindings/freebasic/libopenmpt_ext.bi` were missing from the
    Autotools package.

 *  [**New**] New `Makefile` `CONFIG=mingw-w64` option
    `WINDOWS_CRT=[crtdll,msvcrt,ucrt]` to select the toolchain CRT library.

 *  [**Change**] `build/download_externals.sh` now verifies the integrity of any
    downloaded files and uses curl instead of wget.

 *  [**Regression**]: Optimization level when compiling with GCC 14 has been
    forced down to `-O1` due to the severe miscompilation GCC 14 has shown on
    MinGW-w64 amd64 (see <https://gcc.gnu.org/bugzilla/show_bug.cgi?id=115049>).

 *  IT: Disable a few more compatibility flags for older SchismTracker builds.
 *  IT: Halve the output volume of files saved with ChibiTracker, as its mixer
    is about half as loud as ours.
 *  S3M: In mono mode, the ratio between sample and OPL volume was incorrect.
 *  S3M: Detect files saved with PlayerPRO.
 *  XM: Detect files saved with PlayerPRO. Improved detection of files saved
    with ModPlug Tracker.
 *  XM: Files with impossibly small pattern headers are now rejected, like
    FastTracker 2 does.
 *  STK: Loosen SoundTracker file rejection heuristics a bit to allow loading of
    files with malformed song titles and overly long samples.
    Other heuristics has been tightened a bit.
 *  MOD: Change VBlank timing heuristic to always assume CIA timing when long
    samples unsupported by original ProTracker) are found.
 *  MOD: Disable NoiseTracker quirks if empty sample slots have a default volume
    other than 0.
 *  MOD: 7-bit panning detection may have returned incorrect results for MODs
    with a channel count other than 4.
 *  MED: Improve handling of default tempo, panning and channel volume in files
    containing more than one song.
 *  MO3: Reduced maximum allowed music data (not samples) size from 2 GiB to
    512 MiB.
 *  XMF: Header validation is now stricter.
 *  MDL: Slightly more accurate import of pattern command 9 (enabling envelopes
    instead of setting envelope position).
 *  ULT: Support the highest three octaves.
 *  OPL emulation could produce clicks when using a mix rate higher than
    65536 Hz.

 *  xmp-openmpt: Subsongs whose length could not be calculate no longer show a
    duration of -12:-55.

 *  mpg123: Update to v1.32.6 (2024-04-04).

### libopenmpt 0.7.6 (2024-03-24)

 *  [**Sec**] Potential heap out-of-bounds read or write past sample end with
    malformed sustain loops in SymMOD files (r20420).

 *  MED: Transposed samples were playing too low in some files (e.g.
    mix94.mmd1).
 *  OKT: Some files with garbage at the end were rejected (e.g.
    katharsis - piano lesson.okta).
 *  Compressor DMO: It was possible that the plugin would not behave as intended
    at mix rates above 500 kHz.
 *  Avoid re-allocating the loop state map contents on every playthrough of the
    module.

### libopenmpt 0.7.5 (2024-03-17)

 *  [**Sec**] Null-pointer write (32bit platforms) or excessive memory
    allocation (64bit platforms) when reading close to 4GiB of data from
    unseekable files (r20336, r20338).
 *  [**Sec**] Write buffer overflow when reading unseekable files close to
    4GiB in size (r20339).
 *  [**Sec**] Possible out-of-memory (32bit platforms) or excessive memory
    allocation (64bit platforms) when reading malformed data from unseekable
    files (r20340).
 *  [**Sec**] DMF: Possible null-pointer write or excessive memory allocation
    when reading DMF files (r20323).

 *  IT: In the previous version, Zxx macros in IT files made with older MPT
    versions were no longer working.
 *  There was a periodic click when playing a module using the Chorus or Flanger
    DMO plugin at a mix rate exceeding ~136.5 kHz.
 *  An older bugfix for undefined behaviour in the Distortion DMO plugin was
    incorrect, causing the distorted sound to be different in some situations.

 *  xmp-openmpt: Metadata retrievel for playlist items was broken.

### libopenmpt 0.7.4 (2024-03-03)

 *  [**Bug**] Makefile: libopenmpt 0.7.3 broke running the test suite for
    Emscripten builds.

 *  openmpt123: openmpt123 now uses a narrower layout on terminal windows with a
    width of less than 72 characters.

 *  Setting all possible `load_skip` flags resulted in nothing being loaded at
    all, instead of just not loading the selected module parts.
 *  When playing all subsongs, `set_position_seconds` didn't always calculate
    the correct subsong to jump to.

 *  IT: A few more compatibility flags are now disabled for modules saved with
    earlier Schism Tracker versions.
 *  IT: MIDI macros were reset in IT 2.14 / 2.15 files that declared to be
    compatible with older IT versions (fixes spx-visionsofthepast.it).
 *  OKT: Work around missing negative arpeggio implementation by transposing the
    notes up an octave.
 *  OKT: Channel volume commands were sometimes lost over less important
    effects.
 *  IMF: Ignore magic bytes in sample header. "Leaving All Behind" by Karsten
    Koch uses unexpected magic bytes, Orpheus ignores them just like the
    instrument header magic bytes.

 *  zlib: Update to v1.3.1 (2024-01-22).
 *  mpg123: Update to v1.32.5 (2024-02-17).
 *  pugixml: Update to v1.14 (2023-10-01).

### libopenmpt 0.7.3 (2023-09-09)

 *  [**Bug**] Makefile: Emscripten 3.1.31 stopped exporting `malloc` and `free`.
    We now explicitly export those again to keep compatibility.

 *  `set_pitch_factor` no longer affected  OPL instruments since version 0.6.0.

 *  FLAC: Update to v1.4.3 (2022-06-23).
 *  zlib: Update to v1.3 (2022-08-18).

### libopenmpt 0.7.2 (2023-06-18)

 *  [**Sec**] Possible out-of-bounds read or write when reading malformed MED
    files. (r19389)

 *  [**New**] MOD: Can now read modified 8-channel MOD files from the DOS game
    Aleshar - The World Of Ice.

 *  [**Bug**] The C++ API failed to compile with Clang/Emscripten in some
    situations due to a misplaced `[[deprecated]]`.
 *  [**Bug**] The Opal OPL3 emulator symbols were not namespaced properly.
 *  [**Bug**] Work-around for MSVC VS2022 17.6.0 ARM64 compiler bug.
 *  [**Bug**] `Makefile` `CONFIG=emscripten EMSCRIPTEN_PORTS=1` failed to
    properly use `libogg` and `libvorbis` dependencies. 

### libopenmpt 0.7.1 (2023-05-07)

 *  [**Bug**] MSVC projects failed to build from the packaged source zip.

 *  IT: Improved fingerprinting of early ModPlug Tracker versions.
 *  XMF: Modules from Astroidea demos can now be read as well.

### libopenmpt 0.7.0 (2023-04-30)

 *  [**New**] `667` files from Composer 667 are now supported.
 *  [**New**] `GTK` and `GT2` files from Gramouf Tracker are now supported.
 *  [**New**] Can now read a variant of the DSMI AMF format called DMF, as found
    in various DOS games distributed by Webfoot (Tronic, H2O, PowBall, etc.).
 *  [**New**] `DSM` files from Dynamic Studio are now supported.
 *  [**New**] `XMF` files from the DOS game Imperium Galactica are now
    supported.
 *  [**New**] Can now read the hacked MOD format (`DMF`) from the game
    "Apocalypse Abyss".
 *  [**New**] libopenmpt: New APIs for getting the current tempo as a floating
    point value: `openmpt::module::get_current_tempo2()` (C++), and
    `openmpt_module_get_current_tempo2()` (C).
 *  [**New**] C API: New stream callbacks for various platform extensions to the
    C stdio interface: `openmpt_stream_get_file_posix_lfs64_callbacks()` in
    `libopenmpt/libopenmpt_stream_callbacks_file_posix_lfs64.h` for explicit
    `off64_t` on Posix systems, `openmpt_stream_get_file_posix_callbacks()` in
    `libopenmpt/libopenmpt_stream_callbacks_file_posix.h` for `off_t` on Posix
    systems, `openmpt_stream_get_file_msvcrt_callbacks()` in
    `libopenmpt/libopenmpt_stream_callbacks_file_msvcrt.h` for 64bit file
    support on Windows systems with the Microsoft C runtime, and
    `openmpt_stream_get_file_mingw_callbacks()` in
    `libopenmpt/libopenmpt_stream_callbacks_file_mingw.h` for 64bit file support
    when targetting MinGW. The old `openmpt_stream_get_file_callbacks()` has
    been deprecated in favour of a stricly standard conforming
    `openmpt_stream_get_file_callbacks2()` in the same
    `libopenmpt/libopenmpt_stream_callbacks_file.h` header.
    `libopenmpt/libopenmpt.h` defines
    `LIBOPENMPT_STREAM_CALLBACKS_FILE_POSIX_LFS64`,
    `LIBOPENMPT_STREAM_CALLBACKS_FILE_POSIX`,
    `LIBOPENMPT_STREAM_CALLBACKS_FILE_MSVCRT`, and
    `LIBOPENMPT_STREAM_CALLBACKS_FILE_MINGW` respectively in order to allow for
    checking header availability.
 *  [**New**] C API: New stream callbacks for memory buffers.
    `openmpt_stream_get_buffer_callbacks()` and `openmpt_stream_buffer_init()`
    are deprecated. Use `openmpt_stream_get_buffer_callbacks2()` and
    `openmpt_stream_buffer_init2()` instead. The new variants do not support
    loading only a file prefix and checking for overflow any more. This was only
    useful when using the old `openmpt_could_open_probability2()` style
    interface from the libopenmpt 0.2 API, which has been superseded by
    `openmpt_probe_file_header()`,
    `openmpt_probe_file_header_without_filesize()`, and
    `openmpt_probe_file_header_from_stream()` in libopenmpt 0.3.0.
 *  [**New**] libopenmpt_ext: New interface `interactive3` adding
    `openmpt::ext::interactive3::set_current_tempo2()` (C++) and
    `openmpt_module_ext_interface_interactive3.set_current_tempo2()` (C) which
    allow setting non-integer tempo values. 
 *  [**New**] New `Makefile` option `CONFIG=mingw-w64` which consolidates all
    MinGW-w64 build configurations with the following options:
    `MINGW_FLAVOUR=[|-posix|-win32]`, `WINDOWS_ARCH=[x86|amd64]`,
    `WINDOWS_FAMILY=[|desktop-app|app|phone-app|pc-app]`, and
    `WINDOWS_VERSION=[win95|win98|winme|winnt4|win2000|winxp|winxp64|winvista|win7|win8|win8.1|win10|win11]`.
 *  [**New**] New `Makefile` option `CONFIG=mingw` which consolidates all MinGW
    build configurations with the following options:
    `MINGW_FLAVOUR=[|-posix|-win32]`, and
    `WINDOWS_VERSION=[win95|win98|winme|winnt4|win2000|winxp]`.
 *  [**New**] Building with MSYS2 is now fully supported for Makefile and
    Autotools build systems.
 *  [**New**] `Makefile` `CONFIG=djgpp` now supports `CPU=` option to build
    optimized for a particular CPU. See `build/make/config-djgpp.mk` for all
    available options. `FLAVOURED_DIR=1` places the CPU-specific optimized
    builds in separate folders below `bin/`.
 *  [**New**] Building with a MinGW32 CRTDLL toolchain is now supported via
    `Makefile` option `CONFIG=mingw32crt`.
 *  [**New**] `Makefile` now uses `PKG_CONFIG` as path to `pkg-config`.
 *  [**New**] The C++ API is now also enabled for Emscripten builds by default.
 *  [**New**] Support for GCC 7 has been restored.
 *  [**New**] Support for Clang 6 has been restored.
 *  [**New**] Support for Android NDK 18 has been restored.
 *  [**New**] openmpt123: `--banner [0|1|2]` allows changing the openmpt123
    banner style to hidden, shown, or verbose, respectively.
 *  [**New**] openmpt123: `--assume-terminal` allows skipping the openmpt123
    terminal check, and thus allows running the UI with non-terminal stdin,
    which can be useful for some very basic remote control functionality.

 *  [**Change**] xmp-openmpt: The Amiga resampler emulation is now enabled by
    default.
 *  [**Change**] in_openmpt: The Amiga resampler emulation is now enabled by
    default.
 *  [**Change**] The official Windows builds (x86, amd64, arm, arm64) now
    require Windows 10 21H2 (or later). The official legacy Windows builds
    (x86-legacy, amd64-legacy) are unchanged and still require Windows 7 (or
    later).
 *  [**Change**] `"date"` metadata will now exlude the UTC time zone signifier
    `Z` if the precise time zone is unknown.
 *  [**Change**] ctl `seek.sync_samples` now defaults to 1.
 *  [**Change**] `Makefile` `CONFIG=generic` is gone. Please use
    `CONFIG=standard` instead.
 *  [**Change**] `Makefile` `CONFIG=macosx` and `CONFIG=haiku` have been
    removed. The OS is auto-detected.
 *  [**Change**] `Makefile` options `CONFIG=mingw64-win32`,
    `CONFIG=mingw64-win64`, `CONFIG=mingw64-winrt-x86`,
    `CONFIG=mingw64-winrt-amd64`, and `CONFIG=mingw-win9x` have been replaced by
    `CONFIG=mingw-w64`, and `CONFIG=mingw`.
 *  [**Change**] Autotools now default to C++20 and only fall back to C++17 when
    C++20 is not supported.
 *  [**Change**] `Makefile` now defaults to C++20 and only falls back to C++17
    when C++20 is not supported by the compiler.
 *  [**Change**] `Makefile` now defaults to C17 and only falls back to C11 when
    C17 is not supported by the compiler.
 *  [**Change**] `Makefile` `CONFIG=djgpp` option `USE_ALLEGRO42` now
    defaults to `1` and implies building a liballegro42 locally. This requires
    executing `build/download_externals.sh` before building to download the
    liballegro42 sources.
 *  [**Change**] in_openmpt: The Winamp input plugin in_openmpt is now
    deprecated for use with the latest Winamp or WACUP releases. Please use the
    native implementations available in Winamp >=5.9.0 or WACUP instead. This
    does not mean that in_openmpt/in_mod will not receive further development,
    it just means that the responsibility now lies with the player implementors
    themselves. We will still maintain the status quo of our in_openmpt input
    plugin for users of earlier Winamp version, or users on older systems, or
    users of compatible players.
 *  [**Change**] The POSIX fd file callbacks implementation now handles `EINTR`
    and retries the `read()` call.

 *  [**Regression**] Full support for Visual Studio 2017 has been removed. We
    still support targeting Windows XP with Visual Studio 2017.
 *  [**Regression**] Support for mingw-std-threads has been removed. If you
    require a thread-safe libopenmpt, please build with POSIX threading model
    and/or complain to MinGW/GCC about not properly supporting C++11 features in
    2023.
 *  [**Regression**] Support for Emscripten versions older than 3.1.1 has been
    removed.
 *  [**Regression**] C API: `openmpt_stream_get_file_callbacks()` used to
    provide 64bit file access on some platforms where long is 32bit. This never
    worked reliably for all platforms though. The behaviour is now changed to
    always stick to what standard C supports with `fseek` and `ftell`, where the
    offset type is long. `openmpt_stream_get_file_callbacks()` is deprecated now
    due to behavioral change. Please migrate to
    `openmpt_stream_get_file_callbacks2()`.
 *  [**Regression**] Using the system-provided liballegro42 is no longer
    supported. The option `BUNDLED_ALLEGRO42=1` does not exist any more.

 *  Reduced aliasing when downsampling with the Sinc + Low-Pass resampler.
 *  The sample position is now rounded instead of truncated when resampling
    without interpolation.
 *  Seeking with sample sync now supports portamento up / down commands as well
    as IMF/ PTM note slides. Tone portamento is now synchronized correctly when
    seeking in DBM, 669 and MED with fast slides (first tick of portamento was
    previously not executed).
 *  The filter cutoff frequency is no longer rounded to integer frequency
    values.
 *  MED: Tempos higher than 255 BPM can now be imported in pattern data.
 *  MED: MMD1 files with more than 16 channels are now supported.
 *  ULT: Import 8-bit volume commands with full precision.
 *  IT: Initial "last note memory" of every channel is C-0, so a lone instrument
    number without note triggers that note.
 *  S3M: Better approximation of old "stereo control" SAx command used in
    Purple Motion's PANIC.S3M.
 *  S3M: In ScreamTracker 3.03 and later, OPL notes with tone portamento next to
    them are delayed until the next row and then the new pitch is used
    instantly.
 *  MO3: Envelope sustain was not imported correctly if the source file was an
    XM.
 *  MOD: Lone instrument number with retrigger effect swap sample immediately.
 *  Recalling a sample's default volume using an instrument number (as opposed
    to regular volume commands) previously ramped the volume change smoothly
    over a whole tick. Now the user-configured ramp settings are used instead
    (as it would happen when using a volume command to achieve the same effect).

 *  zlib: v1.2.12 (2022-03-27).
 *  mpg123: v1.31.3 (2023-03-19).
 *  ogg: v1.3.5 (2021-06-04).
 *  vorbis: v1.3.7 (2020-07-04).
 *  miniz: v2.2.0 (2021-06-27).
 *  minimp3: commit 50d2aaf360a53653b718fead8e258d654c3a7e41 (2021-11-27).
 *  stb_vorbis: v1.22 commit 5a0bb8b1c1b1ca3f4e2485f4114c1c8ea021b781
    (2021-07-12).
 *  FLAC: v1.4.2 (2022-10-22).
 *  PortAudio: v19.7.0 (2021-04-06).

### libopenmpt 0.6.0 (2021-12-23)

 *  [**New**] `MUS` files from Psycho Pinball and Micro Machines 2 are now
    supported.
 *  [**New**] `SymMOD` files created with Symphonie / Symphonie Pro are now
    supported.
 *  [**New**] `FMT` files created with Davey W Taylor's FM Tracker are now
    supported.
 *  [**New**] `DSYM` files created with Digital Symphony are now supported.
 *  [**New**] `STX` files (transitional format between Scream Tracker 2 and 3)
    are now supported.
 *  [**New**] TakeTracker MODs with `TDZ1` to `TDZ3` magic bytes are now
    supported.
 *  [**New**] openmpt123: openmpt123 will now expand file wildcards passed on
    the command line in Windows when built with MSVC.
 *  [**New**] libopenmpt_ext: New interface `interactive2` adding
    `openmpt::ext::interactive2::note_off()`,
    `openmpt::ext::interactive2::note_fade()`,
    `openmpt::ext::interactive2::set_channel_panning()`,
    `openmpt::ext::interactive2::get_channel_panning()`,
    `openmpt::ext::interactive2::set_note_finetune()`, and
    `openmpt::ext::interactive2::get_note_finetune()` (C++) and
    `openmpt_module_ext_interface_interactive2.note_off()`,
    `openmpt_module_ext_interface_interactive2.note_fade()`,
    `openmpt_module_ext_interface_interactive2.set_channel_panning()`,
    `openmpt_module_ext_interface_interactive2.get_channel_panning()`,
    `openmpt_module_ext_interface_interactive2.set_note_finetune()`, and
    `openmpt_module_ext_interface_interactive2.get_note_finetune()` (C). 
 *  [**New**] `Makefile` `CONFIG=emscripten` now supports
    `EMSCRIPTEN_TARGET=audioworkletprocessor` which builds an ES6 module in
    a single file with reduced dependencies suitable to be used in an
    AudioWorkletProcessor.
 *  [**New**] `Makefile` `CONFIG=emscripten` now supports `EMSCRIPTEN_PORTS=1`
    which uses dependencies (zlib, mp123, ogg, and vorbis) from Emscripten Ports
    instead of using miniz, minimp3, and stb_vorbis locally or building zlib,
    mp123, ogg, and vorbis locally.
 *  [**New**] `Makefile` `CONFIG=emscripten` and `CONFIG=djgpp` can now build
    zlib, mpg123, and vorbis locally instead of only supporting miniz, minimp3,
    and stb_vorbis via `ALLOW_LGPL=1`.

 *  [**Change**] `Makefile` `CONFIG=emscripten` now supports
    `EMSCRIPTEN_TARGET=all` which provides WebAssembly as well as fallback to
    JavaScript in a single build.
 *  [**Change**] openmpt123: DOS builds now use the Mercury fork of
    `liballegro 4.2` for improved hardware compatibility.
 *  [**Change**] libopenmpt no longer generates internal interpolation tables on
    library load time, but instead only on first module load time.

 *  [**Regression**] `Makefile` `CONFIG=emscripten` does not support
    `EMSCRIPTEN_TARGET=asmjs` or `EMSCRIPTEN_TARGET=asmjs128m` any more because
    support has been removed from current Emscripten versions.
 *  [**Regression**] Support for GCC 7 has been removed.
 *  [**Regression**] Support for Clang 5, 6 has been removed.
 *  [**Regression**] Support for Emscripten versions older than 1.39.7 has been
    removed.
 *  [**Regression**] Building with Android NDK older than NDK r19c is not
    supported any more.

 *  libopenmpt can now detect infinite pattern loops and treats them as the song
    end. This means that setting a repeat count other than -1 now always
    guarantees that playback will eventually end. The song loop counter is
    decremented each time it ends up at the start of the infinite loop, so the
    song does not restart from the beginning even if the repeat count is not 0.
 *  `openmpt::module::set_position_seconds()` accuracy has been improved for
    modules with pattern loops.
 *  Samples played at the wrong volume when rendering modules in mono.
 *  IT: Portamentos in files with Linear Slides disabled are now more accurate.
 *  IT: Pitch/Pan Separation was affected by note-off commands, and wasn't reset
    by panning commands like in Impulse Tracker.
 *  IT: Even after libopenmpt 0.5.14 the filter reset logic was still not 100%
    identical to Impulse Tracker: A note triggered on tick 0 of a row with a
    Pattern Delay effect still caused the filter to be reset on repetitions of
    that row even though the note wasn't retriggered.
 *  IT: Added read-only support for BeRoTracker commands 1 and 2 (equivalent to
    XM commands K and L).
 *  XM: BeRoTracker saves smooth MIDI macros in a different way from OpenMPT.
    This command is now imported correctly.
 *  XM: Emulate FT2 Tone Portamento quirk that inverts portamento direction
    after the target was reached (if target note was higher than previous note).
 *  S3M files saved with Impulse Tracker and latest Schism Tracker now also
    compute sample playback speed in Hertz.
 *  Depending on whether an S3M file was last saved in Scream Tracker with the
    Sound Blaster or Gravis Ultrasound drivers loaded, different compatibility
    flags are now applied. For files saved with the GUS, the sample volume
    factor is now also ignored (fixes volume levels in S3Ms made on the GUS, in
    particular if they use both samples and OPL instruments).
 *  S3M: Enforce the lower frequency bound.
 *  MOD: Loosened VBlank timing heuristics so that the original copy of
    Guitar Slinger from Dizzy Tunes II plays correctly.
 *  FAR: Correct portamento depth is now used.
 *  DMF / IMF: Improved accuracy of finetune commands.
 *  MDL: Implemented finetune command.
 *  OKT: Various accuracy improvements such as: Sharing volume between mixed
    channels, volume commands on mixed channels are permanent (not reset with
    new notes), mixed channels do not support default sample volume, 7-bit
    samples are actually supposed to be played as-is (not amplified to full
    8-bit range), reject speed command parameters >= 20.

 *  zlib: v1.2.11 (2017-01-15).
 *  mpg123: v1.29.3 (2021-12-11).
 *  ogg: v1.3.5 (2021-06-04).
 *  vorbis: v1.3.7 (2020-07-04).
 *  miniz: v2.2.0 (2021-06-27).
 *  minimp3: commit 50d2aaf360a53653b718fead8e258d654c3a7e41 (2021-11-27).
 *  stb_vorbis: v1.22 commit 5a0bb8b1c1b1ca3f4e2485f4114c1c8ea021b781
    (2021-07-12).
 *  FLAC: v1.3.3 (2019-08-04).
 *  PortAudio: v19.7.0 (2021-04-06).

### libopenmpt 0.5.0 (2020-05-24)

 *  [**New**] OggMod compressed FastTracker 2 XM (OXM) modules are now
    supported.
 *  [**New**] The emulated Amiga type when Amiga resampler emulation is enabled
    can now be selected via ctl `render.resampler.emulate_amiga_type`. Possible
    values are: `"auto"`, `"a500"`, `"a1200"`, and an experimental option
    `"unfiltered"`.
 *  [**New**] libopenmpt: New API `openmpt::module::get_current_estimated_bpm()`
    (C++), and `openmpt_module_get_current_estimated_bpm()` (C) which provides
    accurate beats per minute information for module formats with time signature
    and an educated guess based on speed and tempo for others.
 *  [**New**] libopenmpt: New type-aware ctl APIs that do not require memory
    allocations and are thus realtime-safe:
    `openmpt::module::ctl_get_boolean()`, `openmpt::module::ctl_get_integer()`,
    `openmpt::module::ctl_get_floatingpoint()`,
    `openmpt::module::ctl_get_text()`, `openmpt::module::ctl_set_boolean()`,
    `openmpt::module::ctl_set_integer()`,
    `openmpt::module::ctl_set_floatingpoint()` (C++), and
    `openmpt_module_ctl_get_boolean()`, `openmpt_module_ctl_get_integer()`,
    `openmpt_module_ctl_get_floatingpoint()`, `openmpt_module_ctl_get_text()`,
    `openmpt_module_ctl_set_boolean()`, `openmpt_module_ctl_set_integer()`,
    `openmpt_module_ctl_set_floatingpoint()` (C).
 *  [**New**] libopenmpt C++ New API `openmpt::is_extension_supported2()` which
    takes a `std::string_view` parameter instead of `std::string`.
 *  [**New**] libopenmpt C++: New API
    `openmpt::module::module(std::vector<std::byte> data)`,
    `openmpt::module::module(const std::byte * data, std::size_t size)`,
    `openmpt::module::module(const std::byte * beg, const std::byte * end)`.
 *  [**New**] libopenmpt C++: New API
    `openmpt::probe_file_header(flags, const std::byte * data, std::size_t size, filesize)`,
    `openmpt::probe_file_header(flags, const std::byte * data, std::size_t size)`.
 *  [**New**] libopenmpt_ext C++: New API
    `openmpt::module_ext::module_ext(std::vector<std::byte> data)`,
    `openmpt::module_ext::module_ext(const std::byte * data, std::size_t size)`,
    `openmpt::module_ext::module_ext(std::vector<std::uint8_t> data)`,
    `openmpt::module_ext::module_ext(const std::uint8_t * data, std::size_t size)`.

 *  [**Change**] std::istream based file I/O has been speed up.
 *  [**Change**] Dependency on iconv on Linux has been removed.

 *  [**Regression**] libmodplug: The libmodplug emulation layer has been removed
    from the libopenmpt tree. Please use the separate `libopenmpt-modplug`
    package instead.
 *  [**Regression**] foo_openmpt: foo_openmpt is discontinued. Please use
    Kode54's fork foo_openmpt54:
    <https://www.foobar2000.org/components/view/foo_openmpt54>.
 *  [**Regression**] Support for building with C++11 or C++14 has been removed.
    C++17 is now required to build libopenmpt.
 *  [**Regression**] Support for client code using C++11 or C++ 14 has been
    removed. C++17 is now required to build libopenmpt client applications.
 *  [**Regression**] Support for Visual Studio 2015 has been removed.
 *  [**Regression**] Support for GCC 4.8, 4.9, 5, 6 has been removed.
 *  [**Regression**] Support for Clang 3.6, 3.7, 3.8, 3.9, 4 has been removed.
 *  [**Regression**] Support for Emscripten versions older than 1.39.1 has been
    removed.
 *  [**Regression**] Building with Android NDK older than NDK r18b is not
    supported any more.
 *  [**Regression**] openmpt123: Support for SDL1 (but not SDL2) output has been
    removed.
 *  [**Regression**] openmpt123: Support for SDL2 older than 2.0.4 has been
    removed.
 *  [**Regression**] Windows XP and Windows Vista are no longer supported.
 *  [**Regression**] It is no longer possible to optionally use iconv for
    character set conversions.

 *  [**Bug**] openmpt123: openmpt123 now honors the current locale and outputs
    text appropriately.
 *  [**Bug**] openmpt123: Piping text output to other than console window
    targets on Windows has been fixed.

 *  Greatly improved MED import. Synthesized instruments are still not supported
    but support was added for: Multisampled instruments, delta samples, more
    pattern commands, Hold and Decay, multiple songs and many other small
    changes.
 *  Improved OPL channel allocation when more than 18 notes are active, so that
    channels that have completely faded out are prioritized over channels that
    have already been released but have not faded out yet.
 *  Interactively triggering an OPL instrument could cause the first pattern
    channel to no longer be played back correctly.
 *  Fix some inaccuracies in OPL emulator.
 *  Fix overflow of OPL amplification happening at a synth volume level of 510.
 *  End-of-sample pop reduction of surround channels was applied to front
    channels instead, causing a pop on the front channels instead of removing it
    on the back channels.
 *  IT: Disable retrigger with short notes quirk for modules saved with
    Chibi Tracker, as it does not implement that quirk.
 *  IT: Instrument and sample panning should not override channel panning for
    following notes.
 *  IT: SBx is now prioritized over Bxx commands that are to the left of it.
 *  IT: Duplicate Check Type "Sample" should only be applied if the instruments
    match, too.
 *  IT: Duplicate Check Type "Note" should compare pattern notes, but it was
    comparing the new pattern note against the old translated note.
 *  IT: Various fixes for envelope resetting.
 *  IT / S3M: When combining SBx and EEx effects, don't skip the first row of
    the loop like in FastTracker 2.
 *  S3M: Empty pattern commands now affect effect memory as well.
 *  S3M: Offset beyond loop end wraps around to loop start like in
    Scream Tracker 3 + GUS (previously it just keep playing from the loop start,
    which is neither what GUS nor Sound Blaster drivers do).
 *  S3M: Notes cannot be retriggered after they have been cut.
 *  S3M: Fix portamento after note cut (fixes antediluvian_song.s3m).
 *  S3M / MOD: Previous note offset is no longer used for retriggered notes if
    there was no instrument number next to the Qxy effect.
 *  MOD: Sample swapping now also works if the sample that is being swapped from
    does not loop. Swapping to a non-looped sample now stops playback once the
    swapped-from sample reaches its (loop) end.
 *  MOD: Fix early song ending due to ProTracker pattern jump quirk
    (EEx + Dxx on same row) if infinite looping is disabled.
    Fixes Haunted Tracks.mod by Triace.
 *  MOD: Previous note offset is no longer used for retriggered notes if there
    was no instrument number next to the E9x effect.
 *  MOD: Vibrato type "ramp down" was upside down.
 *  XM: If a file contains patterns longer than 1024 rows, they are now clamped
    to 1024 rows instead of 64 rows.
 *  XM: Do not reset note-off status on portamento if there is no instrument
    number.

 *  mpg123: v1.26rc3.
 *  ogg: v1.3.4.
 *  vorbis: v1.3.6.
 *  zlib: v1.2.11.
 *  minimp3: commit 55da78cbeea5fb6757f8df672567714e1e8ca3e9 (2020-03-04).
 *  stb_vorbis: v1.19 commit 37b9b20fdec06c75a0493e0bb59e2d0f288bfb51
    (2020-02-05).
 *  miniz: v2.1.0.
 *  FLAC: v1.3.3.
 *  PortAudio: commit 799a6834a58592eadc5712cba73b35956dc51579 (2020-03-26).

### libopenmpt 0.4.0 (2018-12-23)

 *  [**New**] libopenmpt now includes emulation of the OPL chip and thus plays
    OPL instruments in S3M, C67 and MPTM files. OPL chip emulation volume can be
    changed with the new ctl `render.opl.volume_factor`.
 *  [**New**] libopenmpt now supports CDFM / Composer 670 module files.
 *  [**New**] Autotools `configure` and plain `Makefile` now honor the variable
    `CXXSTDLIB_PCLIBSPRIVATE` which serves the sole purpose of listing the
    standard library (or libraries) required for static linking. The contents of
    this variable will be put in `libopenmpt.pc` `Libs.private` and used for
    nothing else. See \ref libopenmpt_c_staticlinking .
 *  [**New**] foo_openmpt: foo_openmpt now also works on Windows XP.
 *  [**New**] libopenmpt Emscripten builds now ship with MP3 support by
    default, based on minimp3 by Lion (github.com/lieff).
 *  [**New**] libopenmpt: New ctl `play.at_end` can be used to change what
    happens when the song end is reached:
     *  "fadeout": Fades the module out for a short while. Subsequent reads
        after the fadeout will return 0 rendered frames. This is the default and
        identical to the behaviour in previous libopenmpt versions. 
     *  "continue": Returns 0 rendered frames when the song end is reached.
        Subsequent reads will continue playing from the song start or loop
        start. This can be used for custom loop logic, such as loop
        auto-detection and longer fadeouts.
     *  "stop": Returns 0 rendered frames when the song end is reached.
        Subsequent reads will return 0 rendered frames.
 *  [**New**] Add new metadata fields `"originaltype"` and `"originaltype_long"`
    which allow more clearly reflecting what is going on with converted formats
    like MO3 and GDM.
 *  [**New**] `Makefile` `CONFIG=emscripten` now can generate WebAssembly via
    the additional option `EMSCRIPTEN_TARGET=wasm`.
 *  [**New**] Compiling for DOS is now experimentally supported via DJGPP GCC
    7.2 or later.

 *  [**Change**] minimp3: Instead of the LGPL-2.1-licensed minimp3 by KeyJ,
    libopenmpt now uses the CC0-1.0-licensed minimp3 by Lion (github.com/lieff)
    as a fallback if libmpg123 is unavailable. The `USE_MINIMP3` `Makefile`
    option is gone and minimp3 will be used automatically in the `Makefile`
    build system if libmpg123 is not available.
 *  [**Change**] openmpt123: openmpt123 now rejects `--output-type` in `--ui`
    and `--batch` modes and also rejects `--output` in `--render` mode. These
    combinations of options really made no sense and were rather confusing.
 *  [**Change**] Android NDK build system now uses libc++ (`c++_shared`) instead
    of GNU libstdc++ (`gnustl_shared`), as recommended by Android NDK r16b.
 *  [**Change**] xmp-openmpt: `openmpt-mpg123.dll` is no longer optional and
    must be placed into the same directory as `xmp-openmpt.dll`.
 *  [**Change**] in_openmpt: `openmpt-mpg123.dll` is no longer optional and must
    be placed either into the directory of the player itself or into the same
    directory as `in_openmpt.dll`. This is dependent on how the player loads its
    plugins. For WinAMP 5, `openmpt-mpg123.dll` needs to be in the directory
    which contains `winamp.exe`. `in_openmpt.dll` needs to be in the `Plugins`
    directory.
 *  [**Change**] foo_openmpt: foo_openmpt is now packaged as a fb2k-component
    package for easier installation.
 *  [**Change**] When building libopenmpt with MinGW-w64, it is now recommended
    to use the posix thread model (as opposed to the win32 threading model),
    because the former does support std::mutex while the latter does not. When
    building with win32 threading model with the Autotools build system, it is
    recommended to provide the `mingw-std-threads` package. Building libopenmpt
    with MinGW-w64 without any `std::thread`/`std::mutex` support is deprecated
    and support for such configurations will be removed in libopenmpt 0.5.
 *  [**Change**] `Makefile` `CONFIG=emscripten` now has 4 `EMSCRIPTEN_TARGET=`
    settings: `wasm` generates WebAssembly, `asmjs128m` generates asm.js with a
    fixed size 128MB heap, `asmjs` generates asm.js with a fixed default size
    heap (as of Emscripten 1.38.11, this amounts to 16MB), `js` generates
    JavaScript with dynamic heap growth and with compatibility for older VMs.
 *  [**Change**] libmodplug: Update public headers to libmodplug 0.8.8.5. This
    adds support for kind-of automatic MODPLUG_EXPORT decoration on Windows.

 *  [**Regression**] Support for Clang 3.4, 3.5 has been removed.
 *  [**Regression**] Building with Android NDK older than NDK r16b is not
    supported any more.
 *  [**Regression**] Support for Emscripten versions older than 1.38.5 has been
    removed.
 *  [**Regression**] Support for libmpg123 older than 1.14.0 has been removed.
 *  [**Regression**] Using MediaFoundation to decode MP3 samples is no longer
    supported. Use libmpg123 or minimp3 instead.
 *  [**Regression**] libmodplug: Support for emulating libmodplug 0.8.7 API/ABI
    has been removed.

 *  [**Bug**] xmp-openmpt: Sample rate and number of output channels were not
    applied correctly when using per-file settings.
 *  [**Bug**] Internal mixer state was not initialized properly when initially
    rendering in 44100kHz stereo format.
 *  [**Bug**] openmpt123: Prevent libsdl2 and libsdl from being enabled at the
    same time because they conflict with each other.
 *  [**Bug**] libmodplug: Setting `SNDMIX_NORESAMPLING` in the C++ API always
    resulted in linear interpolation instead of nearest neighbour

 *  IT: In Compatible Gxx mode, allow sample changes next to a tone portamento
    effect if a previous sample has already stopped playing.
 *  IT: Fix broken volume envelopes with negative values as found in breakdwn.it
    by Elysis.
 *  MOD: Slides and delayed notes are executed on every repetition of a row with
    row delay (fixes "ode to protracker").
 *  XM: If the sustain point of the panning envelope is reached before key-off,
    it is never released.
 *  XM: Do not default recall volume / panning for delayed instrument-less notes
 *  XM :E60 loop bug was not considered in song length calucation.
 *  S3M: Notes without instrument number use previous note's sample offset.
 *  Tighten STK and MOD file rejection heuristics.
 *  J2B: Ignore frequency limits from file header. Fixes Medivo.j2b, broken
    since libopenmpt-0.2.6401-beta17.
 *  STM: More accurate tempo calculation.
 *  STM: Better support for early format revisions (no such files have been
    found in the wild, though).
 *  STM: Last character of sample name was missing.
 *  SFX: Work around bad conversions of the "Operation Stealth" soundtrack by
    turning pattern breaks into note stops.
 *  IMF: Filter cutoff was upside down and the cutoff range was too small.
 *  ParamEq plugin center frequency was not limited correctly.
 *  Keep track of active SFx macro during seeking.
 *  The "note cut" duplicate note action did not volume-ramp the previously
    playing sample.
 *  A song starting with non-existing patterns could not be played.
 *  DSM: Support restart position and 16-bit samples.
 *  DTM: Import global volume.
 *  MOD: Support notes in octave 2, like in FastTracker 2 (fixes DOPE.MOD).
 *  Do not apply Amiga playback heuristics to MOD files that have clearly been
    written with a PC tracker.
 *  MPTM: More logical release node behaviour.
 *  Subsong search is now less thorough. It could previously find many subsongs
    that are technically correct (unplayed rows at the beginning of patterns
    that have been jumped over due to pattern breaks), but so far no real-world
    module that would require such a thorough subsong detection was found. The
    old mechanism caused way more false positives than intended with real-world
    modules, though.
 *  Restrict the unpacked size of compressed DMF, IT, MDL and MO3 samples to
    avoid huge allocations with malformed small files.

### libopenmpt 0.3 (2017-09-27)

 *  [**New**] New error handling functionality in the C API, which in particular
    allows distinguishing potentially transient out-of-memory errors from parse
    errors during module loading. 
 *  [**New**] New API `openmpt::module::get_selected_subsong()` (C++) and
    `openmpt_module_get_selected_subsong()` (C).
 *  [**New**] Faster file header probing API `openmpt::probe_file_header()` and
    `openmpt::probe_file_header_get_recommended_size` (C++), and
    `openmpt_probe_file_header()`,
    `openmpt_probe_file_header_without_filesize()`,
    `openmpt_probe_file_header_from_stream()` and
    `openmpt_probe_file_header_get_recommended_size()` (C).
 *  [**New**] New API `openmpt::could_open_probability()` (C++) and
    `openmpt_could_open_probability()` (C). This fixes a spelling error in the
    old 0.2 API.
 *  [**New**] openmpt123: openmpt123 can now open M3U, M3U8, M3UEXT, M3U8EXT and
    PLSv2 playlists via the `--playlist` option.
 *  [**New**] openmpt123: openmpt123 now supports very fast file header probing
    via the `--probe` option.
 *  [**New**] Libopenmpt now supports building for Windows 10 Universal (Windows
    Store 8.2) APIs with MSVC, and also for the older Windows Runtime APIs with
    MinGW-w64.
 *  [**New**] New API header `libopenmpt_ext.h` which implements the libopenmpt
    extension APIs also for the C interface.
 *  [**New**] The Reverb effect (S99 in S3M/IT/MPTM, and X99 in XM) is now
    implemented in libopenmpt.
 *  [**New**] For Amiga modules, a new resampler based on the Amiga's sound
    characteristics has been added. It can be activated by passing the
    `render.resampler.emulate_amiga` ctl with a value of `1`. Non-Amiga modules
    are not affected by this, and setting the ctl overrides the resampler choice
    specified by `OPENMPT_MODULE_RENDER_INTERPOLATIONFILTER_LENGTH` or
    `openmpt::module::RENDER_INTERPOLATIONFILTER_LENGTH`. Support for the MOD
    command E0x (Set LED Filter) is also available when the Amiga resampler is
    enabled. 

 *  [**Change**] libopenmpt versioning changed and follows the more conventional
    major.minor.patch as well as the recommendations of the
    [SemVer](http://semver.org/) scheme now. In addition to the SemVer
    requirements, pre-1.0.0 versions will also honor API and ABI stability in
    libopenmpt (i.e. libopenmpt ignores SemVer Clause 4). 
 *  [**Change**] The output directories of the MSVC build system were changed to
    `bin/vs2015-shared/x86-64-win7/` (and similar) layout which allows building
    in the same tree with different compiler versions without overwriting other
    outputs.
 *  [**Change**] The emscripten build now exports libopenmpt as 'libopenmpt'
    instead of the default 'Module'.
 *  [**Change**] Android: The build system changed. The various Android.mk files
    have been merged into a single one which can be controlled using command
    line options.
 *  [**Change**] The `Makefile` build system now passes `std=c++11` to the
    compiler by default. Older compilers may still work if you pass
    `STDCXX=c++0x` to the `make` invocation.
 *  [**Change**] The `Makefile` option `ANCIENT=1` is gone.
 *  [**Change**] The optional dependencies on `libltdl` or `libdl` are gone.
    They are no longer needed for any functionality.

 *  [**Regression**] Compiling client code using the C++ API now requires a
    compiler running in C++11 mode.
 *  [**Regression**] Support for GCC 4.1, 4.2, 4.3, 4.4, 4.5, 4.6, 4.7 has been
    removed.
 *  [**Regression**] Support for Clang 3.0, 3.1, 3.2, 3.3 has been removed.
 *  [**Regression**] Support for Emscripten versions older than 1.31.0 has been
    removed.
 *  [**Regression**] Support for Android NDK versions older than 11 has been
    removed.
 *  [**Regression**] Visual Studio 2008, 2010, 2012, 2013 support has been
    removed.
 *  [**Regression**] Dynamic run-time loading of libmpg123 is no longer
    supported. Libmpg123 must be linked at link-time now.
 *  [**Regression**] xmp-openmpt: xmp-openmpt now requires XMPlay 3.8 or later
    and compiling xmp-openmpt requires an appropriate XMPlay SDK with
    `XMPIN_FACE` >= `4`.
 *  [**Regression**] Support for libmpg123 older than 1.13.0 has been removed.
 *  [**Regression**] Un4seen unmo3 support has been removed.

 *  [**Bug**] C++ API: `openmpt::exception` did not define copy and move
    constructors or copy and move assignment operators in libopenmpt 0.2. The
    compiler-generated ones were not adequate though. libopenmpt 0.3 adds the
    appropriate special member functions. This adds the respective symbol names
    to the exported ABI, which, depending on the compiler, might or might not
    have been there in libopenmpt 0.2. The possibly resulting possible ODR
    violation only affects cases that did crash in the libopenmpt 0.2 API anyway
    due to memory double-free, and does not cause any further problems in
    practice for all known platforms and compilers.
 *  [**Bug**] The C API could crash instead of failing gracefully in
    out-of-memory situations.
 *  [**Bug**] The test suite could fail on MacOSX or FreeBSD in non-fatal ways
    when no locale was active.
 *  [**Bug**] `libopenmpt_stream_callbacks_fd.h` and
    `libopenmpt_stream_callbacks_file.h` were missing in Windows development
    packages.
 *  [**Bug**] libopenmpt on Windows did not properly guard against current
    working directory DLL injection attacks.
 *  [**Bug**] localtime() was used to determine the version of Schism Tracker
    used to save IT and S3M files. This function is not guaranteed to be
    thread-safe by the standard and is now no longer used.
 *  [**Bug**] Possible crashes with malformed IT, ITP, AMS, MDL, MED, MPTM, PSM
    and Startrekker files.
 *  [**Bug**] Possible hangs with malformed DBM, MPTM and PSM files.
 *  [**Bug**] Possible hangs with malformed files containing cyclic plugin
    routings.
 *  [**Bug**] Excessive loading times with malformed ITP / truncated AMS files.
 *  [**Bug**] Plugins did not work correctly when changing the sample rate
    between two render calls.
 *  [**Bug**] Possible NULL-pointer dereference read during obscure
    out-of-memory situations while handling exceptions in the C API.
 *  [**Bug**] libmodplug: `libmodplug.pc` was wrong.
 *  [**Bug**] Cross-compiling libopenmpt with autotools for Windows now properly
    sets `-municode` and `-mconsole` as well as all required Windows system
    libraries.
 *  [**Bug**] foo_openmpt: Interpolation filter and volume ramping settings were
    confused in previous versions. This version resets both to the defaults.
 *  [**Bug**] libmodplug: The CSoundFile::Read function in the emulated
    libmodplug C++ API returned the wrong value, causing qmmp (and possibly
    other software) to crash.

 *  Support for SoundTracker Pro II (STP) and Digital Tracker (DTM) modules.
 *  Increased accuracy of the sample position and sample rate to drift less when
    playing very long samples.
 *  Various playback improvements for IT and XM files.
 *  Channel frequency could wrap around after some excessive portamento / down
    in some formats since libopenmpt 0.2-beta17.
 *  Playback improvements for S3M files made with Impulse Tracker and
    Schism Tracker.
 *  ParamEq plugin emulation didn't do anything at full gain (+15dB).
 *  All standard DMO effects are now also emulated on non-Windows and non-MSVC
    systems.
 *  Added `libopenmpt_stream_callbacks_buffer.h` which adds
    `openmpt_stream_callbacks` support for in-memory buffers, possibly even only
    using a truncated prefix view into a bigger file which is useful for
    probing.
 *  Avoid enabling some ProTracker-specific quirks for MOD files most likely
    created with ScreamTracker 3.
 *  Tremolo effect only had half the intended strength in MOD files.
 *  Pattern loops ending on the last row a pattern were not executed correctly
    in S3M files.
 *  Work-around for reading MIDI macros and plugin settings in some malformed IT
    files written by old UNMO3 versions.
 *  Improve tracker detection in IT format.
 *  Playback fixes for 8-channel MED files
 *  Do not set note volume to 0 on out-of-range offset in XM files.
 *  Better import of some slide commands in SFX files.
 *  Sample 15 in "Crew Generation" by Necros requires short loops at the
    beginning of the sample to not be ignored. Since we need to ignore them in
    some (non-ProTracker) modules, we heuristically disable the old loop
    sanitization behaviour based on the module channel count.
 *  Both normal and percentage offset in PLM files were handled as percentage
    offset.
 *  MT2 files with instruments that had both sample and plugin assignments were
    not read correctly.
 *  Some valid FAR files were rejected erroneously.
 *  Support for VBlank timing flag and comment field in PT36 files.
 *  Improved accuracy of vibrato command in DIGI / DBM files.
 *  STM: Add support for "WUZAMOD!" magic bytes and allow some slightly
    malformed STM files to load which were previously rejected.
 *  Detect whether "hidden" patterns in the order list of SoundTracker modules
    should be taken into account or not.
 *  Tighten heuristics for rejecting invalid 669, STK, MOD and ICE files and
    loosen them in other places to allow some valid MOD files to load.
 *  Improvements to seeking: Channel panning was not always updated from
    instruments / samples when seeking, and out-of-range global volume was not
    applied correctly in some formats.
 *  seek.sync_samples=1 did not apply PTM reverse offset effect and the volume
    slide part of combined volume slide + vibrato commands.
 *  If the order list was longer than 256 items and there was a pattern break
    effect without a position jump on the last pattern of the sequence, it did
    not jump to the correct restart order.
 *  `Makefile` has now explicit support for FreeBSD with no special option or
    configuration required.
 *  openmpt123: Improved section layout in man page.
 *  libmodplug: Added all missing C++ API symbols that are accessible via the
    public libmodplug header file.
 *  Autotools build system now has options `--disable-openmpt123`,
    `--disable-tests` and `--disable-examples` which may be desireable when
    cross-compiling.
 *  Windows binary packages now ship with libmpg123 included.

### libopenmpt 0.2-beta20 (2016-08-07)

 *  [**Bug**] PSM loader was broken on big-endian platforms since forever.
 *  [**Bug**] `load.skip_samples` ctl did not work for PSM16 modules.

 *  There is a new `subsong` ctl, which can return the currently selected
    subsong.
 *  More accurate ProTracker arpeggio wrap-around emulation.
 *  More accurate sample tuning in PSM16 files.
 *  Samples in DSM files were sometimes detuned and some pattern commands were
    not imported correctly.
 *  More accurate import of MDL 7-bit panning command.
 *  Only import pattern commands supported by the UltraTracker version that was
    used to save ULT files. Add support for command 5-C (end loop).
 *  DMF sample loop lengths were off by one.
 *  Unis 669 pan slide effect was too deep.
 *  Several valid (but slightly corrupted possibly due to disk failures or data
    transfer errors) SoundTracker files were no longer loading since libopenmpt
    0.2-beta18.

### libopenmpt 0.2-beta19 (2016-07-23)

 *  [**Change**] libopenmpt now uses C++14 `[[deprecated]]` attribute instead
    of compiler-specific solutions when appropriate.
 *  [**Change**] libopenmpt C++ header now uses C++11 `noexcept` instead of
    C++98 `throw()` exception specification when supported. `throw()` is
    deprecated since C++11. This does not change API or ABI as they are
    equivalent. Use `LIBOPENMPT_ASSUME_CPLUSPLUS_NOEXCEPT` to override the
    default.
 *  [**Change**] The preprocessor macro `LIBOPENMPT_ANCIENT_COMPILER_STDINT` is
    gone. Please use `LIBOPENMPT_ASSUME_CPLUSPLUS_CSTDINT instead`.
    Additionally, the typedefs moved from illegal namespace ::std into somewhat
    less dangerous namespace ::openmpt::std. You can test
    `#ifdef LIBOPENMPT_QUIRK_NO_CSTDINT` client-side to check whether
    `libopenmpt.hpp` used the non-standard types. (Note: Of all supported
    compilers, this change only affects the 3 compilers with only limited
    support: MSVC 2008, GCC 4.1, GCC 4.2.)

 *  [**Bug**] xmp-openmpt: Crash when viewing sample texts.

 *  The public libopenmpt C++ header has auto-detection logic for the used C++
    standard now. In case your client code compiler misreports the standard
    version or you want to override it for other reasons,
    `#define LIBOPENMPT_ASSUME_CPLUSPLUS` to the value of the standard version
    you desire to be used. There is also a macro for each individual aspect,
    like `LIBOPENMPT_ASSUME_CPLUSPLUS_CSTDINT`,
    `LIBOPENMPT_ASSUME_CPLUSPLUS_DEPRECATED`,
    `LIBOPENMPT_ASSUME_CPLUSPLUS_NOEXCEPT` which take precedence over the
    general macro.
 *  Portamento with sample swap behaviour was wrong for ProTracker MODs.
 *  Rewritten loader and various playback fixes for MDL files.
 *  libopenmpt 0.2-beta18 broke import of many pattern commands in DBM, DMF and
    ULT files.
 *  ADPCM samples in MOD files were broken since libopenmpt 0.2-beta17.

### libopenmpt 0.2-beta18 (2016-07-11)

 *  [**Change**] openmpt123: Add PulseAudio output support. Autotools and
    `Makefile` build systems now depend on `libpulse` and `libpulse-simple` by
    default. Disable with `--without-pulseaudio` or `NO_PULSEAUDIO=1`
    respectively. When enabled, PulseAudio will be the default output driver,
 *  [**Change**] xmp-openmpt: Settings are now stored in xmplay.ini like with
    every other plugin.

 *  [**Regression**] openmpt123: Support for FLAC < 1.3.0 has been removed. FLAC
    before 1.3.0 is broken beyond repair as it provides `assert.h` in the
    include path.

 *  [**Bug**] Generated pkg-config file libopenmpt.pc by both `Makefile` and
    Autotools build systems was totally broken.
 *  [**Bug**] libopenmpt no longer uses the non-thread-safe global std::rand()
    function.
 *  [**Bug**] Sample loops in GDM modules did not work when using Emscripten.
 *  [**Bug**] XM and MO3 loaders could crash due to unaligned memory accesses.
 *  [**Bug**] Fixed incorrect handling of custom MPTM tunings on big endian
    platforms.
 *  [**Bug**] Fixed various problems found with clang 3.8 static analyzer,
    address sanitizer and undefined behaviour sanitizer.
 *  [**Bug**] File header probing functionality was broken for most formats.
 *  [**Bug**] With non-seekable streams, the entire file was almost always
    cached even if it was not of any supported module type.

 *  Seeking in allsubsongs-mode now works correctly.
 *  openmpt123: Added subsong support.
 *  Various playback fixes for 669, IT, MT2 and MTM files.
 *  Some MOD files with more than 128 patterns (e.g. NIETNU.MOD) were not loaded
    correctly.
 *  A new example `libopenmpt_example_c_probe` has been added which demonstrates
    the usage and flexibility of openmpt_could_open_propability() in the C API
    under various constraints.

### libopenmpt 0.2-beta17 (2016-05-21)

 *  [**Change**] The Makefile and Autotools build systems now require to
    explicitly specify `NO_LTDL=1` or `--without-ltdl` respectively if no
    support for dynamic loading of third party libraries via libtool libltdl is
    desired.
 *  [**Change**] In the Makefile build system option `USE_MO3` and the Autotools
    build system option `--enable-mo3` are gone. Dynamic loading of un4seen
    unmo3 is now always enabled when dynamic loading is possible and built-in
    MO3 support is not possible because either a MP3 or a Vorbis decoder is
    missing.
 *  [**Change**] The MSVC build system changed. The `libopenmptDLL` project is
    gone. Use the new `ReleaseShared` configuration of the `libopenmpt` project
    instead. libopenmpt now links against zlib by default. A separate project
    with smaller footprint linking against miniz is still available as
    `libopenmpt-small`.
 *  [**Change**] The constants used to query library information from
    `openmpt_get_string()` and `openmpt::string::get()` (i.e. OPENMPT_STRING_FOO
    and openmpt::string::FOO) have been deprecated because having syntactic
    constants for theses keys makes extending the API in a backwards and
    forwards compatible way harder than it should be. Please just use the string
    literals directly.
 *  [**Change**] Deprecated API identifiers will now cause deprecation warnings
    with MSVC, GCC and clang. `#define LIBOPENMPT_NO_DEPRECATE` to disable the
    warnings.
 *  [**Change**] openmpt123: `--[no-]shuffle` option has been renamed to
    `--[no-]randomize`. A new `--[no-]shuffle` option has been added which
    shuffles randomly through the playlist as opposed to randomizing the
    playlist upfront.
 *  [**Change**] Support for Un4seen unmo3 has generally been deprecated in
    favour of the new internal mo3 decoder. Un4seen unmo3 support will be
    removed on 2018-01-01.

 *  [**Bug**] Memory consumption during loading has been reduced by about 1/3 in
    case a seekable input stream is provided (either via C API callback open
    functions or via C++ API iostream constructors).
 *  [**Bug**] Some samples in AMS modules were detuned when using Emscripten.
 *  [**Bug**] Possible crash with excessive portamento down in some formats.
 *  [**Bug**] Possible crashes with malformed AMF, AMS, DBM, IT, MDL, MED, MPTM,
    MT2, PSM and MMCMP-, XPK- and PP20-compressed files.
 *  [**Bug**] `openmpt::module::format_pattern_row_channel` with `width == 0`
    was returning an empty string instead of an string with unconstrained
    length.

 *  Support for ProTracker 3.6 IFF-style modules and SoundFX / MultiMedia Sound
    (SFX / MMS) modules.
 *  libopenmpt now has support for DMO plugins on Windows when built with MSVC.
    Additionally, the DMO Compression, Distortion, Echo, Gargle, ParamEQ and
    WavesReverb DSPs are emulated on on all other platforms.
 *  libopenmpt now supports the DigiBooster Echo DSP.
 *  To avoid any of the aforementioned plugins to be used, the load.skip_plugins
    ctl can be passed when loading a module.
 *  libopenmpt got native MO3 support with MP3 decoding either via libmpg123 or
    MediaFoundation (on Windows 7 and up) and Vorbis decoding via libogg,
    libvorbis, libvorbisfile or stb_vorbis.
 *  libopenmpt MSVC builds with Visual Studio 2010 or later on Windows 7 or
    later now use an internal MO3 decoder with libogg, libvorbis, libvorbisfile,
    and libmpg123 or minimp3 or MediaFoundation suppport by default. Visual
    Studio 2008 builds still use unmo3.dll by default but also support the
    built-in decoder in which case libmpg123 is required.
 *  libopenmpt with Makefile or Autotools build system can now also use
    glibc/libdl instead of libtool/libltdl for dynamic loading of third-party
    libraries. Options `NO_DL=1` and `--without-dl` have been added
    respectively.
 *  The `Makefile` build system got 4 new options NO_MPG123, NO_OGG, NO_VORBIS,
    NO_VORBISFILE. The default is to use the new dependencies automatically.
 *  The `Autotools` build system got 4 new options --without-mpg123,
    --without-ogg, --without-vorbis, --without-vorbisfile. The default is to use
    the new dependencies automatically.
 *  Makefile and Android builds got support for using minimp3 instead of
    libmpg123. For Android, use `Android-minimp3-stbvorbis.mk`, for Makefile use
    `USE_MINIMP3=1`. You have to download
    [minimp3](http://keyj.emphy.de/minimp3/) yourself and put its contents into
    `include/minimp3/`.
 *  `"source_url"`, `"source_date"` and `"build_compiler"` keys have been added
    to `openmpt_string_get()` and `openmpt::string::get()`.
 *  openmpt123: Add new `--[no-]restart]` option which restarts the playlist
    when finished.
 *  Improved Ultimate SoundTracker version detection heuristics.
 *  Playing a sample at a sample rate close to the mix rate could lead to small
    clicks when using vibrato.
 *  More fine-grained internal legacy module compatibility settings to correctly
    play back modules made with older versions of OpenMPT and a few other
    trackers.
 *  The tail of compressed MDL samples was slightly off.
 *  Some probably hex-edited XM files (e.g. cybernostra weekend.xm) were not
    loaded correctly.
 *  Countless other playback fixes for MOD, XM, S3M, IT and MT2 files.

### libopenmpt 0.2-beta16 (2015-11-22)

 *  [**Change**] The Autotools build system does strict checking of all
    dependencies now. Instead of best effort auto-magic detection of all
    potentially optional dependencies, the default set of dependencies is now
    enforced unless each individual dependency gets explicitely disabled via
    `--without-foo` or `--disable-foo` `./configure` switches. Run
    `./configure --help` for the full list of options.

 *  [**Bug**] Some MOD files were erroneously detected as 669 files.
 *  [**Bug**] Some malformed AMF files could result in very long loading times.
 *  [**Bug**] Fixed crashes in IMF and MT2 loaders.
 *  [**Bug**] MTM files generated by UNMO3 were not loaded properly.
 
 *  Improved MTM playback.
 *  `make CONFIG=haiku` for Haiku has been added.
 *  Language bindings for FreeBASIC have been added (see
    `libopenmpt/bindings/`).

### libopenmpt 0.2-beta15 (2015-10-31)

 *  [**Change**] openmpt123: SDL2 is now supported and preferred to SDL1 if
    available with the `Makefile` build system.

 *  [**Bug**] Emscripten support for older emscripten versions broke in -beta14.
    These are now supported again when using `make CONFIG=emscripten-old`.
 *  [**Bug**] Fixed crashes in MED loader.

 *  Playback improvements and loader fixes for MOD, MT2 and MED.

### libopenmpt 0.2-beta14 (2015-09-13)

 *  [**Change**] The C++ API example now uses the PortAudio C++ bindings
    instead of the C API.
 *  [**Change**] Default compiler options for Emscripten have been changed to
    more closely match the Emscripten recommendations.

 *  [**Bug**] Client code compilation with C89 compilers was broken in beta13.
 *  [**Bug**] Test suite failed on certain Emscripten/node.js combinations.
 *  [**Bug**] Fixed various crashes or hangs in DMF, OKT, PLM, IT and MPTM
    loaders.

 *  Implemented error handling in the libopenmpt API examples.
 *  Various playback improvements and fixes for OKT, IT and MOD.

### libopenmpt 0.2-beta13 (2015-08-16)

 *  [**Change**] The MSVC build system has been redone. Solutions are now
    located in `build/vsVERSION/`.

 *  [**Bug**] get_current_channel_vu_left and get_current_channel_vu_right only
    return the volume of the front left and right channels now.
    get_current_channel_vu_rear_left and get_current_channel_vu_rear_right
    do now actually work and return non-zero values.
 *  [**Bug**] Fix crashes and hangs in MED and MDL loaders and with some
    truncated compressed IT samples.
 *  [**Bug**] Fix crash when playing extremely high-pitched samples.

 *  Completed C and C++ documentation
 *  Added new key for openmpt::module::get_metadata, "message_raw", which
    returns an empty string if there is no song message rather than a list of
    instrument names.
 *  in_openmpt: Support for compiling with VS2008.
 *  xmp-openmpt: Support for compiling with VS2008.
 *  in_openmpt: Add a more readable file information window.

### libopenmpt 0.2-beta12 (2015-04-19)

 *  Playback fix when row delay effect is used together with offset command.
 *  A couple of fixes for the seek.sync_samples=1 case.
 *  IT compatibility fix for IT note delay.
 *  ProTracker MOD playback compatibility improvement.

### libopenmpt 0.2-beta11 (2015-04-18)

 *  [**Change**] openmpt_stream_seek_func() now gets called with
    OPENMPT_STREAM_SEEK_SET, OPENMPT_STREAM_SEEK_CUR and
    OPENMPT_STREAM_SEEK_END whence parameter instead of SEEK_SET, SEEK_CUR and
    SEEK_END. These are defined to 0, 1 and 2 respectively which corresponds to
    the definition in all common C libraries. If your C library uses different
    constants, this theoretically breaks binary compatibility. The old
    libopenmpt code, however, never actually called the seek function, thus,
    there will be no problem in practice.
 *  [**Change**] openmpt123: When both SDL1.2 and PortAudio are available,
    SDL is now the preferred backend because SDL is more widespread and better
    tested on all kinds of different platforms, and in general, SDL is just
    more reliable.

 *  [**Bug**] libopenmpt now also compiles with GCC 4.3.

 *  libopenmpt now supports PLM (Disorder Tracker 2) files.
 *  Various playback improvements and fixes for IT, S3M, XM, MOD, PTM and 669
    files.

### libopenmpt 0.2-beta10 (2015-02-17)

 *  [**Change**] Makefile configuration filenames changed from
    `build/make/Makefile.config.*` to `build/make/config-*.mk`.
 *  [**Change**] libopenmpt for Android now supports unmo3 from un4seen. See
    `build/android_ndk/README.AndroidNDK.txt` for details.

 *  [**Bug**] Fix out-of-bounds read in mixer code for ProTracker-compatible
    MOD files which was introduced back in r4223 / beta6.

 *  Vibrato effect was too weak in beta8 and beta9 in IT linear slide mode.
 *  Very small fine portamento was wrong in beta8 and beta9 in IT linear slide
    mode.
 *  Tiny IT playback compatibility improvements.
 *  STM playback improvements.

### libopenmpt 0.2-beta9 (2014-12-21)

 *  [**Bug**] libopenmpt_ext.hpp was missing from the Windows binary zip files.

### libopenmpt 0.2-beta8 (2014-12-21)

 *  [**Change**] foo_openmpt: Settings are now accessible via foobar2000
    advanced settings.
 *  [**Change**] Autotools based build now supports libunmo3. Specify
    --enable-unmo3.
 *  [**Change**] Support for dynamic loading of libunmo3 on MacOS X.
 *  [**Change**] libopenmpt now uses libltld (from libtool) for dynamic loading
    of libunmo3 on all non-Windows platforms.
 *  [**Change**] Support for older compilers:
     *  GCC 4.1.x to 4.3.x (use `make ANCIENT=1`)
     *  Microsoft Visual Studio 2008 (with latest Service Pack)
        (see `build/vs2008`)
 *  [**Change**] libopenmpt_ext.hpp is now distributed by default. The API is
    still considered experimental and not guaranteed to stay API or ABI
    compatible.
 *  [**Change**] xmp-openmpt / in_openmpt: No more libopenmpt_settings.dll.
    The settings dialog now uses a statically linked copy of MFC.

 *  [**Bug**] The -autotools tarballs were not working at all.

 *  Vastly improved MT2 loader.
 *  Improved S3M playback compatibility.
 *  Added openmpt::ext::interactive, an extension which adds a whole bunch of
    new functionality to change playback in some way or another.
 *  Added possibility to sync sample playback when using
    openmpt::module::set_position_* by setting the ctl value
    seek.sync_samples=1  
 *  Support for "hidden" subsongs has been added.
    They are accessible through the same interface as ordinary subsongs, i.e.
    use openmpt::module::select_subsong to switch between any kind of subsongs.
 *  All subsongs can now be played consecutively by passing -1 as the subsong
    index in openmpt::module::select_subsong.
 *  Added documentation for a couple of more functions.

### libopenmpt 0.2-beta7 (2014-09-07)

 *  [**Change**] libopenmpt now has an GNU Autotools based build system (in
    addition to all previously supported ways of building libopenmpt).
    Autotools support is packaged separately as tarballs ending in
    `-autotools.tar.gz`.

 *  [**Bug**] The distributed windows .zip file did not include pugixml.

 *  [**Regression**] openmpt123: Support for writing WavPack (.wv) files has
    been removed.
    
    Reasoning:
     1. WavPack support was incomplete and did not include support for writing
        WavPack metadata at all.
     2. openmpt123 already supports libSndFile which can be used to write
        uncompressed lossless WAV files which can then be encoded to whatever
        format the user desires with other tools.

### libopenmpt 0.2-beta6 (2014-09-06)

 *  [**Change**] openmpt123: SDL is now also used by default if availble, in
    addition to PortAudio.
 *  [**Change**] Support for emscripten is no longer experimental.
 *  [**Change**] libopenmpt itself can now also be compiled with VS2008.

 *  [**Bug**] Fix all known crashes on platforms that do not support unaligned
    memory access.
 *  [**Bug**] openmpt123: Effect column was always missing in pattern display.

### libopenmpt 0.2-beta5 (2014-06-15)

 *  [**Change**] Add unmo3 support for non-Windows builds.
 *  [**Change**] Namespace all internal functions in order to allow statically
    linking against libopenmpt without risking duplicate symbols.
 *  [**Change**] Iconv is now completely optional and only used on Linux
    systems by default.
 *  [**Change**] Added libopenmpt_example_c_stdout.c, an example without
    requiring PortAudio.
 *  [**Change**] Add experimental support for building libopenmpt with
    emscripten.

 *  [**Bug**] Fix ping-pong loop behaviour which broke in 0.2-beta3.
 *  [**Bug**] Fix crashes when accessing invalid patterns through libopenmpt
    API.
 *  [**Bug**] Makefile: Support building with missing optional dependencies
    without them being stated explicitely.
 *  [**Bug**] openmpt123: Crash when quitting while playback is stopped.
 *  [**Bug**] openmpt123: Crash when writing output to a file in interactive UI
    mode.
 *  [**Bug**] openmpt123: Wrong FLAC output filename in --render mode.

 *  Various smaller playback accuracy improvements.

### libopenmpt 0.2-beta4 (2014-02-25)

 *  [**Bug**] Makefile: Dependency tracking for the test suite did not work.

### libopenmpt 0.2-beta3 (2014-02-21)

 *  [**Change**] The test suite is now built by default with Makefile based
    builds. Use `TEST=0` to skip building the tests. `make check` runs the test
    suite.

 *  [**Bug**] Crash in MOD and XM loaders on architectures not supporting
    unaligned memory access.
 *  [**Bug**] MMCMP, PP20 and XPK unpackers should now work on non-x86 hardware
    and implement proper bounds checking.
 *  [**Bug**] openmpt_module_get_num_samples() returned the wrong value.
 *  [**Bug**] in_openmpt: DSP plugins did not work properly.
 *  [**Bug**] in_openmpt/xmp-openmpt: Setting name for stereo separation was
    misspelled. This version will revert your stereo separation settings to
    default.
 *  [**Bug**] Crash when loading some corrupted modules with stereo samples.

 *  Support building on Android NDK.
 *  Avoid clicks in sample loops when using interpolation.
 *  IT filters are now done in integer instead of floating point. This improves
    performance, especially on architectures with no or a slow FPU.
 *  MOD pattern break handling fixes.
 *  Various XM playback improvements.
 *  Improved and switchable dithering when using 16bit integer API.

### libopenmpt 0.2-beta2 (2014-01-12)

 *  [**Bug**] MT2 loader crash.
 *  [**Bug**] Saving settings in in_openmpt and xmp-openmpt did not work.
 *  [**Bug**] Load libopenmpt_settings.dll also from below Plugins directory in
    Winamp.

 *  DBM playback improvements.

### libopenmpt 0.2-beta1 (2013-12-31)

 *  First release.

